close all;clc;clear;
K1 = [  1242.5754075778295, 0, 311.38367487706199; 
         0,1242.5754075778295, 234.20251269702217;
         0, 0, 1];
K2 = [ 1242.5754075778295, 0, 311.38367487706199;
       0, 1242.5754075778295, 234.20251269702217;
       0, 0, 1 ];
K3 = [ 1242.5754075778295, 0, 311.38367487706199;
       0, 1242.5754075778295, 234.20251269702217;
       0, 0, 1];

K4 = [1242.5754075778295, 0, 311.38367487706199;
      0, 1242.5754075778295, 234.20251269702217;
      0, 0, 1];
K5 = [1242.5754075778295, 0, 311.38367487706199;
      0, 1242.5754075778295, 234.20251269702217;
      0, 0, 1];

R1 = [ 0.99922812698546648, -0.0062971550914430012, 0.038774941378043472; 
        0.0057880954159254651, 0.99989576853968853, 0.013226866895897638; 
        -0.038854191441497488, -0.012992224373830821, 0.99916042451312459];
    
R2 = [0.10571702666587883, 0.99435756445449697, 0.0087717891588122102; 
        -0.98775494620992554, 0.10602468967506251, -0.11445056320147065; 
        -0.114734809498918, 0.0034349951131673645, 0.99339021753680434];
    
R3 = [-0.99577479777242062, 0.087042505255147312, -0.029260116202819302;
        -0.082889560347427282, -0.98912001078821032, -0.1215356945252751; 
        -0.039520537783601151, -0.11859682347027017, 0.9921556937074224];
    
R4 = [-0.072694401273603604, -0.99591811145618103, -0.053503638166260775; 
        0.99604421111117036, -0.069745686932336501, -0.055058774652756007; 
        0.051102382873979169, -0.057294453727131087, 0.997048590609661];
    
R5 = [0.99499594727867813, -0.084624573938131664, 0.053120112808574066; 
        0.087345359563016131, 0.9948627370764046, -0.051175409521099009; 
        -0.048516523595712964, 0.055559120427113071, 0.99727595532808877];
    
C1 = [0.20357943073683216;
      0.10533218850244401;
      -2.0643341647252607];

C2 = [2.1460726052316672;
      -0.036788828493071773;
      -1.9146033199001222];

C3 = [0.2098870216788582; 
      2.8222293890108996;
      -2.0941885750212506];

C4 = [-2.1320741133911212; 
      0.95676995628378303;
      -2.0246966034225604];

C5 = [-0.086808933545418576; 
      -1.7094913535683143;
      -2.0253628602455289];
  
t1 = -1*R1*C1;
t2 = -1*R2*C2;
t3 = -1*R3*C3;
t4 = -1*R4*C4;
t5 = -1*R5*C5;

transMat = eye(4,4);
transMat(1:3,1:3) = R1;
transMat(1:3,4) = t1;

%gettransformation for matrix [R|t]-->[I|0]
tran = inv(transMat);

ext1 = [R1,t1]*tran;
ext2 = [R2,t2]*tran;
ext3 = [R3,t3]*tran;
ext4 = [R4,t4]*tran;
ext5 = [R5,t5]*tran;

Rt1 = ext1(1:3,1:3); tt1 = ext1(1:3,4); %from extrinsic to R and t
Ct1 = -1*Rt1'*tt1;
Rt2 = ext2(1:3,1:3); tt2 = ext2(1:3,4);
Ct2 = -1*Rt2'*tt2;
Rt3 = ext3(1:3,1:3); tt3 = ext3(1:3,4);
Ct3 = -1*Rt3'*tt3;
Rt4 = ext4(1:3,1:3); tt4 = ext4(1:3,4);
Ct4 = -1*Rt4'*tt4;
Rt5 = ext5(1:3,1:3); tt5 = ext5(1:3,4);
Ct5 = -1*Rt5'*tt5;

figure;
plotCamera('Location',Ct1,'Orientation',Rt1,'Opacity',0,'Color','r');hold on;
plotCamera('Location',Ct2,'Orientation',Rt2,'Opacity',0,'Color','g');hold on;
plotCamera('Location',Ct3,'Orientation',Rt3,'Opacity',0,'Color','b');hold on;
plotCamera('Location',Ct4,'Orientation',Rt4,'Opacity',0,'Color','k');hold on;
plotCamera('Location',Ct5,'Orientation',Rt5,'Opacity',0, 'Color','magenta');

grid on
axis equal
axis manual
xlabel('X');
ylabel('Y');
zlabel('Z');

hT21= [0, -tt2(3), tt2(2);
       tt2(3), 0, -tt2(1);
       -tt2(2), tt2(1),0];
F_21 = inv(K2)'*hT21*Rt2*inv(K1);

hT31= [0, -tt3(3), tt3(2);
       tt3(3), 0, -tt3(1);
       -tt3(2), tt3(1),0];
F_31 = inv(K3)'*hT31*Rt3*inv(K1);

hT41= [0, -tt4(3), tt4(2);
       tt4(3), 0, -tt4(1);
       -tt4(2), tt4(1),0];
F_41 = inv(K4)'*hT41*Rt4*inv(K1);

hT51= [0, -tt5(3), tt5(2);
       tt5(3), 0, -tt5(1);
       -tt5(2), tt5(1),0];
F_51 = inv(K5)'*hT51*Rt5*inv(K1);