clear all
close all

FOV_degrees = [54.14,41.67];
plane_of_stitching = [0,0,1,16.5]';


% %7 cm to 15 cm no restrictions on length in that range.
% camera1_t = [-11/2,0,0];
% camera2_t = [0,11/2,0];
% camera3_t = [11/2,0,0];
% camera4_t = [0,-11/2,0];
% 
% camera_t = [camera1_t;camera2_t;camera3_t;camera4_t];
% 
% %45 to 45 degrees in either direction. no restrictions on angle in that
% %range.
% camera_R(:,:,1) = rotateMat(0,0,-pi/2);
% camera_R(:,:,2) = rotateMat(0,0,0);
% camera_R(:,:,3) = rotateMat(0,0,pi/2);
% camera_R(:,:,4) = rotateMat(0,0,pi);
% 
% [area1,overlap_area1] = cam4_area(FOV_degrees, plane_of_stitching, camera_t, camera_R)
% 
% rang = .18*pi;
% camera_R(:,:,1) = rotateMat(0,rang,-pi/2);
% camera_R(:,:,2) = rotateMat(rang,0,0);
% camera_R(:,:,3) = rotateMat(0,-rang,pi/2);
% camera_R(:,:,4) = rotateMat(-rang,0,pi);
% 
% [area2,overlap_area2] = cam4_area(FOV_degrees, plane_of_stitching, camera_t, camera_R)
% %[area3,overlap_area3] = cam_area(FOV_degrees, plane_of_stitching, camera_t, camera_R)

cc = 1;
for t = 3.5:.05:7.5
    for Rang = -pi/3:.05:pi/3
        camera1_t = [-t,0,0];
        camera2_t = [0,t,0];
        camera3_t = [t,0,0];
        camera4_t = [0,-t,0];
        
        camera_t = [camera1_t;camera2_t;camera3_t;camera4_t];
        
        camera_R(:,:,1) = rotateMat(0,Rang,-pi/2);
        camera_R(:,:,2) = rotateMat(Rang,0,0);
        camera_R(:,:,3) = rotateMat(0,-Rang,pi/2);
        camera_R(:,:,4) = rotateMat(-Rang,0,pi);
        
        [area,overlap_areas] = cam4_area(FOV_degrees, plane_of_stitching, camera_t, camera_R);
        overlap_area = sum(sum(overlap_areas));
        %cc, t, Rang, area,overlap_areas
        output(cc,:) = [cc,t,Rang,area,overlap_areas];
        cc = cc + 1;
    end
end
x = 3.5:.05:7.5;
x_shape = size(x);
x_shape = x_shape(2);
y = -pi/3:.05:pi/3;
y_shape = size(y);
y_shape = y_shape(2);
z1 = reshape(output(:,4),[y_shape,x_shape]);
z2 = reshape(output(:,5),[y_shape,x_shape]);
z3 = reshape(output(:,6),[y_shape,x_shape]);
z4 = reshape(output(:,7),[y_shape,x_shape]);


figure
surf(x,180*y/pi, z1)
xlabel('Arm Length (cm)')
ylabel('Angle (deg)')
zlabel('Area (cm^3)')
title('Total Viewable Area')

%figure
%surf(x,y,z2+z3+z4)

figure
surf(x,180*y/pi,z2)
xlabel('Arm Length (cm)')
ylabel('Angle (deg)')
zlabel('Area (cm^3)')
title('Overlap between Cameras 1 and 2')

figure
surf(x,180*y/pi,z3)
xlabel('Arm Length (cm)')
ylabel('Angle (deg)')
zlabel('Area (cm^3)')
title('Overlap between Cameras 1 and 3')

figure
surf(x,180*y/pi,(z2 > 100).*(z3 > 100).*(z4 > 100).*z1)
xlabel('Arm Length (cm)')
ylabel('Angle (deg)')
zlabel('Area (cm^3)')
title('Cost Function')

for k = 1:length(output(:,1))
    if output(k,5) < 50
        output(k,4) = 0;
    end
    if output(k,6) < 50
        output(k,4) = 0;
    end
    if output(k,7) < 50
        output(k,4) = 0;
    end
end
output = sortrows(output,4);
output(end,2:end)