function [area] = FOVarea(FOV_rads,plane_of_stitching,camera_R,camera_t)

corners = FOVcone(FOV_rads,camera_R,camera_t,1);

[ret1, point1] = ray_plane_intersect(plane_of_stitching,corners(:,1)',camera_t);
[ret2, point2] = ray_plane_intersect(plane_of_stitching,corners(:,2)',camera_t);
[ret3, point3] = ray_plane_intersect(plane_of_stitching,corners(:,3)',camera_t);
[ret4, point4] = ray_plane_intersect(plane_of_stitching,corners(:,4)',camera_t);

%[point1;point2;point3;point4]';
[ret1,ret2,ret3,ret4]
%area of a triangle using 3 side lengths is heron's formula. Two triangles 
% make up the quadrilateral. 
if (ret1 == 1) && (ret2 == 1) && (ret3 == 1) && (ret4 == 1)
    area = 0;
elseif (ret1 == 1) || (ret2 == 1) || (ret3 == 1) || (ret4 == 1)
    area = Inf;
else
    area = triangleArea(point1,point2,point3) + triangleArea(point2,point3,point4);
end
