function [ poly ] = array_FOV(FOV_degrees, plane_of_stitching, camera_R, camera_t)
color_array = 'rgbkprgbkprgbkpr';
color_array = 'bbbbbbbbbbbbbbbb';
n = size(camera_R);
n = n(3);

FOV_rads = pi/180.*FOV_degrees;

%Project FOV onto plane of stitching

for i = 1:n
    image(:,:,i) = FOVproject(FOV_rads,plane_of_stitching,camera_R(:,:,i),camera_t(i,:));
end


if (plane_of_stitching(1) == 0) && (plane_of_stitching(2) == 0)
    %assuming plane of stitching is perpendicular to the z axis.
    for i =1:n
        poly(:,:,i) = image(:,1:2,i);
    end
else
    fprintf("ERROR: Plane of stitching not parallel to xy plane.")
    area = 0;
    return
end
for i = 1:n
    k(:,i) = convhull(poly(:,:,i));
    poly_temp(:,:,i) = poly(k(:,i),:,i);
end
poly = poly_temp;

%% Continue work from here.

figure
axis([-20,20,-20,20])
xlabel('Horizontal Coverage (cm)')
ylabel('Vertical Coverage (cm)')
set(gca,'FontSize',16)
hold on
for i = 1:n
    fill(poly(:,1,i),poly(:,2,i),color_array(i))
end


%fill(poly(:,1,1),poly(:,2,1),'r')
%fill(poly(:,1,2),poly(:,2,2),'g')
%fill(poly(:,1,3),poly(:,2,3),'b')
%fill(poly(:,1,4),poly(:,2,4),'k')