function [ area,stereo_area ] = cam4_area(FOV_degrees, plane_of_stitching, camera_t, camera_R)

camera1_t = camera_t(1,:);
camera2_t = camera_t(2,:);
camera3_t = camera_t(3,:);
camera4_t = camera_t(4,:);

camera1_R = camera_R(:,:,1);
camera2_R = camera_R(:,:,2);
camera3_R = camera_R(:,:,3);
camera4_R = camera_R(:,:,4);

FOV_rads = pi/180.*FOV_degrees;

%Project FOV onto plane of stitching
image1 = FOVproject(FOV_rads,plane_of_stitching,camera1_R,camera1_t);
image2 = FOVproject(FOV_rads,plane_of_stitching,camera2_R,camera2_t);
image3 = FOVproject(FOV_rads,plane_of_stitching,camera3_R,camera3_t);
image4 = FOVproject(FOV_rads,plane_of_stitching,camera4_R,camera4_t);


 
if (plane_of_stitching(1) == 0) && (plane_of_stitching(2) == 0)
    %assuming plane of stitching is perpendicular to the z axis.
    poly1 = image1(:,1:2);
    poly2 = image2(:,1:2);
    poly3 = image3(:,1:2);
    poly4 = image4(:,1:2);
else
    fprintf("ERROR: Plane of stitching not parallel to xy plane.")
    poly1 = [0,0];
    poly2 = [0,0];
    poly3 = [0,0];
    poly4 = [0,0];
    area = 0
    return
end
k1 = convhull(poly1);
k2 = convhull(poly2);
k3 = convhull(poly3);
k4 = convhull(poly4);

% Calculate areas of single coverage regions
poly1 = poly1(k1,:);
poly2 = poly2(k2,:);
poly3 = poly3(k3,:);
poly4 = poly4(k4,:);

area1 = polyarea(poly1(:,1),poly1(:,2));
area2 = polyarea(poly2(:,1),poly2(:,2));
area3 = polyarea(poly3(:,1),poly3(:,2));
area4 = polyarea(poly4(:,1),poly4(:,2));

% Calculate areas of double coverage regions
poly12 = intersectPolygons(poly1,poly2);
poly13 = intersectPolygons(poly1,poly3);
poly14 = intersectPolygons(poly1,poly4);
poly23 = intersectPolygons(poly2,poly3);
poly24 = intersectPolygons(poly2,poly4);
poly34 = intersectPolygons(poly3,poly4);

area12 = polyarea(poly12(:,1),poly12(:,2));
area13 = polyarea(poly13(:,1),poly13(:,2));
area14 = polyarea(poly14(:,1),poly14(:,2));
area23 = polyarea(poly23(:,1),poly23(:,2));
area24 = polyarea(poly24(:,1),poly24(:,2));
area34 = polyarea(poly34(:,1),poly34(:,2));

%Calculate areas of triple coverage regions
if (area12 > 0)
    poly123 = intersectPolygons(poly12,poly3);
    poly124 = intersectPolygons(poly12,poly4);
    area123 = polyarea(poly123(:,1),poly123(:,2));
    area124 = polyarea(poly124(:,1),poly124(:,2));
else 
    area123 = 0;
    area124 = 0;
end

if (area13 > 0)
    poly134 = intersectPolygons(poly13,poly4);
    
    area134 = polyarea(poly134(:,1),poly134(:,2));
else
    area134 = 0;
end
if (area23 > 0)
    poly234 = intersectPolygons(poly23,poly4);
    area234 = polyarea(poly234(:,1),poly234(:,2));
else
    area234 = 0;
end



%Calculate areas of Quadruple coverage regions
if (area12 > 0) && (area34 > 0)
    poly1234 = intersectPolygons(poly12,poly34);
    
    area1234 = polyarea(poly1234(:,1),poly1234(:,2));
else 
    area1234 = 0;
end

%Determine the total area seen by at least 1 camera. 
area1s = area1 + area2 + area3 + area4;
area2s =  area12 + area13 + area14 + area23 + area24 + area34;
area3s = area123 + area124 + area134 + area234;
area4s = area1234;
area =  area1s - area2s + area3s - area4s;


%determine the total area seen by at least 2 cameras
% This is not the correct method of doing this. 
area1;
%stereo_area = area2s;
stereo_area = [area12,area13,area14,area23,area24,area34];


% figure
% hold on
% fill(poly1(:,1),poly1(:,2),'r')
% fill(poly2(:,1),poly2(:,2),'g')
% fill(poly3(:,1),poly3(:,2),'b')
% fill(poly4(:,1),poly4(:,2),'k')