function [ area,stereo_area ] = cam_area(FOV_degrees, plane_of_stitching, camera_t, camera_R)
n = size(camera_R);
n = n(3);

FOV_rads = pi/180.*FOV_degrees;

%Project FOV onto plane of stitching

for i = 1:n
    image(:,:,i) = FOVproject(FOV_rads,plane_of_stitching,camera_R(:,:,i),camera_t(i,:));
end


if (plane_of_stitching(1) == 0) && (plane_of_stitching(2) == 0)
    %assuming plane of stitching is perpendicular to the z axis.
    for i =1:n
        poly(:,:,i) = image(:,1:2,i);
    end
else
    fprintf("ERROR: Plane of stitching not parallel to xy plane.")
    area = 0;
    return
end
for i = 1:n
    k(:,i) = convhull(poly(:,:,i));
end

% Calculate areas of single coverage regions
for i=1:n
    poly(k(:,i),:,i)
    poly_temp(:,:,i) = poly(k(:,i),:,i);
    area{1}(i) = polyarea(poly_temp(:,1,i),poly_temp(:,2,i))
end
poly = poly_temp;

% Calculate areas of double coverage regions
area{2} = zeros(n,n);
for j = 1:n
    for k = i+1:n
        poly2{j,k} = intersectPolygons(poly(:,:,j),poly(:,:,k));
        area{2}(j,k) = polyarea(poly2{j,k}(:,1),poly2{j,k}(:,2));
    end
end

% Calculate areas of triple coverage regions
area{3} = zeros(n,n,n);
for i = 1:n
    for j = i+1:n
        for k = j+1:n
            if (area{2}(i,j) > 0)
                poly3{i,j,k} = intersectPolygons(poly2{i,j},poly(:,:,k));
                area{3}(i,j,k) = polyarea(poly3{i,j,k}(:,1),poly3{i,j,k}(:,2));
            end
        end
    end
end

% Calculate areas of quadruple coverage regions
area{4} = zeros(n,n,n,n);
for i = 1:n
    for j = i+1:n
        for k = j+1:n
            for l = k+1:n
                if (area{3}(i,j,k) > 0)
                    poly4{i,j,k,l} = intersectPolygons(poly2{i,j,k},poly(:,:,l));
                    area{4}(i,j,k,l) = polyarea(poly4{i,j,k,l}(:,1),poly4{i,j,k,l}(:,2));
                end
            end
        end
    end
end

% Calculate areas of quintuple coverage regions
% area{3} = zeros(n,n,n);
% for i = 1:n
%     for j = i+1:n
%         for k = j+1:n
%             poly3{i,j,k} = intersectPolygons(poly2{i,j},poly(:,:,k));
%             area{3}(i,j) = polyarea(poly3{i,j,k}(:,1),poly3{i,j,k}(:,2));
%         end
%     end
% end

%% Continue work from here.

%Determine the total area seen by at least 1 camera.
area1s = sum(area{1});
area2s =  sum(sum(area{2}));
area3s = sum(sum(sum(area{3})));
area4s = sum(sum(sum(sum(area{4}))));
area =  area1s - area2s + area3s - area4s;

stereo_area = area{2};

figure
hold on
fill(poly(:,1,1),poly(:,2,1),'r')
fill(poly(:,1,2),poly(:,2,2),'g')
fill(poly(:,1,3),poly(:,2,3),'b')
fill(poly(:,1,4),poly(:,2,4),'k')