clear all
close all

FOV_degrees = [54.14,41.67];
%scene_height = 16.5;
scene_height = 13;
%scene_height = 14;
%scene_height = 1;
camera_distance = 0; %cm
camera_centers = [0,camera_distance;camera_distance,0;0,-camera_distance;-camera_distance,0];

FOV_rads = FOV_degrees./180*pi;
image_width = scene_height*sin(FOV_rads(1)/2);
image_height = scene_height*sin(FOV_rads(2)/2);

% rec_define1 = [camera_centers(1,1) - image_width,camera_centers(1,2)-image_height, image_width*2,image_height*2];
% rec_define2 = [camera_centers(2,1) - image_height,camera_centers(2,2)-image_width, image_height*2,image_width*2];
% rec_define3 = [camera_centers(3,1) - image_width,camera_centers(3,2)-image_height, image_width*2,image_height*2];
% rec_define4 = [camera_centers(4,1) - image_height,camera_centers(4,2)-image_width, image_height*2,image_width*2];
%rec_1 = rectangle('Position',rec_define1,'FaceColor','red')

%figure(1)
% hold on
% rectangle('Position',rec_define1,'EdgeColor','red')
% rectangle('Position',rec_define2,'EdgeColor','blue')
% rectangle('Position',rec_define3,'EdgeColor','green')
% rectangle('Position',rec_define4,'EdgeColor','black')
%t = 1.8;
t = 7.5;
camera_t(1,:) = [-t,0,0];
%camera_t(2,:) = [0,2.8,0];
camera_t(2,:) = [0,1.8,0];
camera_t(3,:) = [t,0,0];
camera_t(4,:) = [0,-t,0];
camera_t(5,:) = [0,t,0];

%Rang_degrees = -20;
Rang_degrees = 0;
Rang = Rang_degrees*pi/180;
camera_R(:,:,1) = rotateMat(0,Rang,-pi/2);
camera_R(:,:,2) = rotateMat(Rang,0,0);
%camera_R(:,:,2) = rotateMat(0,0,0)
camera_R(:,:,3) = rotateMat(0,-Rang,pi/2);
camera_R(:,:,4) = rotateMat(-Rang,0,pi);
camera_R(:,:,5) = rotateMat(0,0,0);
poly = array_FOV(FOV_degrees,[0,0,1,scene_height]',camera_R,camera_t);

figure
showFOV(FOV_rads,camera_R(:,:,1),camera_t(1,:)',scene_height);
showFOV(FOV_rads,camera_R(:,:,2),camera_t(2,:)',scene_height);
showFOV(FOV_rads,camera_R(:,:,3),camera_t(3,:)',scene_height);
showFOV(FOV_rads,camera_R(:,:,4),camera_t(4,:)',scene_height);
showFOV(FOV_rads,camera_R(:,:,5),camera_t(5,:)',scene_height);

% figure(2)
% hold on
% pyramid([camera_centers(1,1),camera_centers(1,2),0],2*image_width,2*image_height,scene_height)
% pyramid([camera_centers(2,1),camera_centers(2,2),0],2*image_height,2*image_width,scene_height)
% pyramid([camera_centers(3,1),camera_centers(3,2),0],2*image_width,2*image_height,scene_height)
% pyramid([camera_centers(4,1),camera_centers(4,2),0],2*image_height,2*image_width,scene_height)
% 
% %minimum scene height is H = distance between cameras/(2*sin(FOV_rads/2))
% min_depth = camera_distance/(2*sin(FOV_rads(2)/2))
