function [output] = intersectPolygons(poly1,poly2)
% polygons of the form [x1,y1;x2,y2...]
n1 = size(poly1);
n1= n1(1);

n2 = size(poly2);
n2= n2(1);

corners = [0,0];

%find poly1 vertexes contained in poly2
for k = 1:n1
    if inpolygon(poly1(k,1),poly1(k,2),poly2(:,1),poly2(:,2))
        corners = [corners;poly1(k,:)];
    end
end

%find poly2 vertexes contained in poly1
for k = 1:n2
    if inpolygon(poly2(k,1),poly2(k,2),poly1(:,1),poly1(:,2))
        corners = [corners;poly2(k,:)];
    end
end

% intersect poly1 edges with poly2 edges.
k1 = convhull(poly1);
k2 = convhull(poly2);

poly1 = poly1(k1,:);
poly2 = poly2(k2,:);

[ix,iy] = polyxpoly(poly1(:,1),poly1(:,2),poly2(:,1),poly2(:,2));
intersection = [ix,iy];

corners = [corners;intersection];

n3 = size(corners);
n3 = n3(1);
if n3 > 3
    corners = corners(2:end,:);
    ordering = convhull(corners);
    output = corners(ordering,:);
else
    output = corners;
end
