function [] = showFOV(FOV_rads,R,t,scale)
%
%scale = 150; % units are millimeters. scale is the depth in millimeters we are showing for each camera. 

direction = sin(FOV_rads./2);

ray1 = scale.*R*[direction(1),direction(2),1]';
ray2 = scale.*R*[-direction(1),direction(2),1]';
ray3 = scale.*R*[direction(1),-direction(2),1]';
ray4 = scale.*R*[-direction(1),-direction(2),1]';
ray5 = scale.*R*[0,0,0]';

face1 = [ray2,ray1,ray3,ray4] + t;
face2 = [ray5,ray1,ray2]+t;
face3 = [ray5,ray1,ray3]+t;
face4 = [ray5,ray2,ray4]+t;
face5 = [ray5,ray3,ray4]+t;


hold on
fill3(face1(1,:),face1(2,:),face1(3,:),'blue')
fill3(face2(1,:),face2(2,:),face2(3,:),'green')
fill3(face3(1,:),face3(2,:),face3(3,:),'red')
fill3(face4(1,:),face4(2,:),face4(3,:),'red')
fill3(face5(1,:),face5(2,:),face5(3,:),'green')